<?php
/**
 * Plugin Name:  Lean Bunker – Restrict REST API by Role
 * Description:  Disabilita le REST API per visitatori anonimi e per ruoli non privilegiati (es. subscriber). Compatibile con Multisite.
 * Version:      1.1.0
 * Author:       Riccardo Bastillo
 * License:      GPL-3.0+
 */

defined('ABSPATH') || exit;

// Ruoli autorizzati ad accedere alle REST API
// Modifica questa lista se vuoi personalizzare
function lean_bunker_rest_allowed_roles() {
    return ['contributor', 'author', 'editor', 'administrator', 'shop_manager']; // WooCommerce compat
}

add_filter('rest_authentication_errors', function($result) {
    if (!empty($result)) {
        return $result;
    }

    // Se non è loggato → blocca
    if (!is_user_logged_in()) {
        return new WP_Error('rest_forbidden', 'Accesso alle REST API riservato.', ['status' => 403]);
    }

    // Se è loggato, controlla il ruolo
    $user = wp_get_current_user();
    $allowed_roles = lean_bunker_rest_allowed_roles();

    // Intersezione tra ruoli utente e ruoli consentiti
    if (empty(array_intersect($user->roles, $allowed_roles))) {
        return new WP_Error('rest_insufficient_role', 'Il tuo ruolo non ha accesso alle REST API.', ['status' => 403]);
    }

    return $result;
});

// Pulizia SEO/sicurezza
remove_action('wp_head', 'rest_output_link_wp_head', 10);
remove_action('wp_head', 'wp_oembed_add_discovery_links', 10);
remove_action('template_redirect', 'rest_output_link_header', 11);

// Disabilita XML-RPC
add_filter('xmlrpc_enabled', '__return_false');